#ifndef _NRF51CFG_H
#define _NRF51CFG_H

#ifndef NRF51
# error NRF51 not defined
#else

# ifndef DEVICE_RAM_SIZE
#  error undefined ram size
# endif

# ifndef MYNEWT_VAL_BLE_MAX_CONNECTIONS
#  define MYNEWT_VAL_BLE_MAX_CONNECTIONS 1
# endif

# ifndef MYNEWT_VAL_BLE_STORE_MAX_BONDS
#  define MYNEWT_VAL_BLE_STORE_MAX_BONDS 1
# endif

# if MYNEWT_VAL_BLE_STORE_MAX_BONDS
#  ifndef MYNEWT_VAL_BLE_STORE_MAX_CCCDS
#   define MYNEWT_VAL_BLE_STORE_MAX_CCCDS 3
#  endif
#  ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PRIVACY
#   define MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PRIVACY (1)
#  endif
# else
#  define MYNEWT_VAL_BLE_STORE_MAX_CCCDS 0
#  ifndef MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PRIVACY
#   define MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PRIVACY (0)
#  endif
# endif

# if (DEVICE_RAM_SIZE) > 16
#  ifndef MYNEWT_VAL_MSYS_1_BLOCK_COUNT
#   define MYNEWT_VAL_MSYS_1_BLOCK_COUNT (12)
#  endif
#  ifndef MYNEWT_VAL_NIMBLE_HOST_TASK_STACK_SIZE
#   define MYNEWT_VAL_NIMBLE_HOST_TASK_STACK_SIZE (2048)
#  endif
# else
#  ifndef MYNEWT_VAL_MSYS_1_BLOCK_COUNT
#   if MYNEWT_VAL_BLE_LL_CFG_FEAT_LL_PRIVACY
#    define MYNEWT_VAL_MSYS_1_BLOCK_COUNT (7)
#   else
#    define MYNEWT_VAL_MSYS_1_BLOCK_COUNT (5)
#   endif
#  endif
#  ifndef MYNEWT_VAL_NIMBLE_HOST_TASK_STACK_SIZE
#   define MYNEWT_VAL_NIMBLE_HOST_TASK_STACK_SIZE (1152)
#  endif
# endif

# ifndef MYNEWT_VAL_NIMBLE_CONTROLLER_TASK_STACK_SIZE
#  define MYNEWT_VAL_NIMBLE_CONTROLLER_TASK_STACK_SIZE (400)
# endif

# ifndef MYNEWT_VAL_MSYS_1_BLOCK_SIZE
#  define MYNEWT_VAL_MSYS_1_BLOCK_SIZE (88)
# endif

# ifndef MYNEWT_VAL_BLE_ATT_PREFERRED_MTU
#  define MYNEWT_VAL_BLE_ATT_PREFERRED_MTU (23)
# endif

# ifndef MYNEWT_VAL_BLE_SM_SC
#  define MYNEWT_VAL_BLE_SM_SC (0)
# endif

# ifndef MYNEWT_VAL_BLE_LL_NUM_SCAN_DUP_ADVS
#  define MYNEWT_VAL_BLE_LL_NUM_SCAN_DUP_ADVS (8)
# endif

# ifndef MYNEWT_VAL_BLE_LL_NUM_SCAN_RSP_ADVS
#  define MYNEWT_VAL_BLE_LL_NUM_SCAN_RSP_ADVS (8)
# endif

# ifndef MYNEWT_VAL_BLE_LL_WHITELIST_SIZE
#  define MYNEWT_VAL_BLE_LL_WHITELIST_SIZE (1)
# endif

# ifndef MYNEWT_VAL_BLE_ATT_SVR_MAX_PREP_ENTRIES
#  define MYNEWT_VAL_BLE_ATT_SVR_MAX_PREP_ENTRIES (5)
# endif

# ifndef MYNEWT_VAL_BLE_GATT_READ_MAX_ATTRS
#  define MYNEWT_VAL_BLE_GATT_READ_MAX_ATTRS (4)
# endif

# ifndef MYNEWT_VAL_BLE_TRANSPORT_EVT_COUNT
#  define MYNEWT_VAL_BLE_TRANSPORT_EVT_COUNT (2)
# endif

# ifndef MYNEWT_VAL_BLE_TRANSPORT_ACL_COUNT
#  define MYNEWT_VAL_BLE_TRANSPORT_ACL_COUNT (4)
# endif

#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_2M_PHY (0)
#define MYNEWT_VAL_BLE_LL_CFG_FEAT_LE_CODED_PHY (0)

#endif /* NRF51 */
#endif /* _NRF51CFG_H */
